/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWReplyParamPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class VWReplyCorrelationSetPanel
extends JPanel {
    public static final int NUM_COLUMNS = 2;
    public static final int COL_NAME = 0;
    public static final int COL_XPATH_QUERY_STRING = 1;
    protected VWReplyParamPanel m_parent = null;
    private DefaultTableCellRenderer m_tableCellRenderer = null;
    private VWInstructionDefinition m_instructionDef = null;
    private JTextField m_replyName = null;
    private String[][] m_replyParams = null;
    private String[] m_replyParamsTableColumnNames = new String[]{VWResource.s_name, VWResource.s_xpathQueryString};
    private VWTable m_replyParamsTable = null;
    private AbstractTableModel m_replyParamsTableModel = null;

    public VWReplyCorrelationSetPanel(VWReplyParamPanel parent, DefaultTableCellRenderer tableCellRenderer, VWInstructionDefinition instruction) {
        this.m_parent = parent;
        this.m_tableCellRenderer = tableCellRenderer;
        this.m_instructionDef = instruction;
        this.setupLayout();
    }

    public void setInstructionDefinition(VWReplyInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        this.reinitialize();
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_nameColon);
        this.m_replyName = new JTextField();
        this.m_replyName.setEditable(false);
        this.m_replyName.setBorder(null);
        JPanel namePanel = new JPanel(new BorderLayout(10, 0));
        namePanel.add((Component)nameLabel, "Before");
        namePanel.add((Component)this.m_replyName, "Center");
        VWToolbarBorder paramsBorder = new VWToolbarBorder(VWResource.s_properties, 0);
        JPanel paramsPanel = paramsBorder.getClientPanel();
        paramsPanel.setLayout(new BorderLayout());
        paramsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_replyParamsTable = new VWTable();
        this.m_replyParamsTable.setRowSelectionAllowed(true);
        this.m_replyParamsTable.setColumnSelectionAllowed(false);
        this.m_replyParamsTable.setSelectionMode(0);
        paramsPanel.add((Component)new JScrollPane(this.m_replyParamsTable), "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)namePanel, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.add((Component)paramsBorder, c);
    }

    private void reinitialize() {
        try {
            this.m_replyParamsTableModel = null;
            String name = ((VWReplyInstruction)this.m_instructionDef).getCorrelationSetName();
            this.m_parent.setTextField(this.m_replyName, name);
            this.m_replyParams = ((VWReplyInstruction)this.m_instructionDef).getCorrelationSetProperties();
            if (this.m_replyParams != null) {
                if (this.m_replyParamsTableModel == null) {
                    this.m_replyParamsTableModel = new AbstractTableModel(){

                        public boolean isCellEditable(int row, int col) {
                            return false;
                        }

                        public String getColumnName(int nColumnIndex) {
                            switch (nColumnIndex) {
                                case 0: {
                                    return VWReplyCorrelationSetPanel.this.m_replyParamsTableColumnNames[0];
                                }
                                case 1: {
                                    return VWReplyCorrelationSetPanel.this.m_replyParamsTableColumnNames[1];
                                }
                            }
                            return null;
                        }

                        public int getColumnCount() {
                            return VWReplyCorrelationSetPanel.this.m_replyParamsTableColumnNames.length;
                        }

                        public int getRowCount() {
                            if (VWReplyCorrelationSetPanel.this.m_replyParams != null) {
                                return VWReplyCorrelationSetPanel.this.m_replyParams.length;
                            }
                            return 0;
                        }

                        public Object getValueAt(int nRowIndex, int nColumnIndex) {
                            try {
                                if (VWReplyCorrelationSetPanel.this.m_replyParams != null && nRowIndex >= 0 && nRowIndex < VWReplyCorrelationSetPanel.this.m_replyParams.length) {
                                    String[] paramDef = VWReplyCorrelationSetPanel.this.m_replyParams[nRowIndex];
                                    if (paramDef == null) {
                                        return null;
                                    }
                                    switch (nColumnIndex) {
                                        case 0: {
                                            return paramDef[0];
                                        }
                                        case 1: {
                                            return paramDef[1];
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                            }
                            return null;
                        }
                    };
                    this.m_replyParamsTable.setModel(this.m_replyParamsTableModel);
                }
                this.m_parent.setupTableCellRenderer(this.m_replyParamsTable, this.m_replyParamsTableModel);
                this.m_replyParamsTableModel.fireTableDataChanged();
                this.m_replyParamsTable.fitColumnsInTable();
                this.m_replyParamsTable.updateUI();
            }
            this.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeReferences() {
        int i;
        this.m_replyName = null;
        for (i = 0; i < this.m_replyParamsTableColumnNames.length; ++i) {
            this.m_replyParamsTableColumnNames[i] = null;
        }
        if (this.m_replyParams != null) {
            for (i = 0; i < this.m_replyParams.length; ++i) {
                this.m_replyParams[i] = null;
            }
        }
        if (this.m_replyParamsTable != null) {
            this.m_replyParamsTable.removeReferences();
            this.m_replyParamsTable = null;
        }
        this.m_replyParamsTableModel = null;
        this.m_parent = null;
        this.m_tableCellRenderer = null;
        this.m_instructionDef = null;
    }
}

